-- Erstellt eine Arbeitsgangruppierung zwischen allen angegebenen a2_ids
SELECT tsystem.function__drop_by_regex( 'ab2_group__add__by__a2_ids', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_group__add__by__a2_ids(VARIADIC _a2_ids integer[]) RETURNS void AS $$
    DECLARE _arrl   integer;
            _i      integer;
    BEGIN

        _arrl := array_length(_a2_ids, 1);
        _i    := 1;

        WHILE _i < _arrl LOOP

            INSERT INTO ab2_group
                        (a2g_a2_id_from, a2g_a2_id_to)
                 VALUES (_a2_ids[_i], _a2_ids[_i+1])
            ON CONFLICT (a2g_a2_id_from, a2g_a2_id_to) DO NOTHING
            ;

            -- das Erste Element mit dem Zweiten, das Zweite mit dem Dritten usw.
            _i := _i + 1;

        END LOOP;

        RETURN;

    END $$ LANGUAGE plpgsql;


-- Erstellt eine Arbeitsgangruppierung zwischen allen angegebenen a2_ids
SELECT tsystem.function__drop_by_regex( 'ab2_group__clear__by__a2_ids__cleanup', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_group__clear__by__a2_ids__cleanup(VARIADIC _a2_ids integer[]) RETURNS void AS $$
    BEGIN

        DELETE FROM ab2_group WHERE a2g_a2_id_from = ANY( _a2_ids )
                                 OR a2g_a2_id_to   = ANY( _a2_ids );

        RETURN;

    END $$ LANGUAGE plpgsql;

/*-- Entfern Arbeitsgangruppierung zwischen angegebenen a2_ids
CREATE OR REPLACE FUNCTION tabk.ab2_group__clear__by__a2_id__from_to(_a2_id_from integer, _a2_id_to integer) RETURNS void AS $$
    BEGIN

        DELETE FROM ab2_group WHERE a2g_a2_id_from = _a2_id_from
                                AND a2g_a2_id_to = _a2_id_to;

        RETURN;

    END $$ LANGUAGE plpgsql;
*/

SELECT tsystem.function__drop_by_regex( 'ab2_group__clear__by__ab_ix', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_group__clear__by__ab_ix(_ab_ix integer) RETURNS void AS $$
    DECLARE _a2_ids integer[];
    BEGIN

        _a2_ids := array_agg(a2_id) FROM ab2 WHERE a2_ab_ix = _ab_ix;

        -- ab2_group__clear__by__a2_ids__cleanup
        DELETE FROM ab2_group WHERE a2g_a2_id_from = ANY( _a2_ids )
                                 OR a2g_a2_id_to   = ANY( _a2_ids );

        RETURN;

    END $$ LANGUAGE plpgsql;

-- Erstellt eine Gruppierung von aufeinanderfolgenden AGs dieser ABK wenn die Resourcen aufeinanderfolgend gleich sind
SELECT tsystem.function__drop_by_regex( 'ab2_group__auto__by__ab_ix', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_group__auto__by__ab_ix( _ab_ix int ) RETURNS void AS $$
    DECLARE
      _ab2_record record;
      _current_ab2_group int[] = array[]::int[];
      _cursor refcursor;
    BEGIN

      -- PERFORM tabk.ab2_group__clear__by__ab_ix(_ab_ix); => NEIN
      -- alle Verknüpfungen innerhalb dieser ABK entfernen (nur auf sich selbst zeigend) => NEIN
      -- DELETE FROM ab2_group WHERE a2g_a2_id_from = ANY( ( SELECT a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix ) )
      --                        AND a2g_a2_id_to   = ANY( ( SELECT a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix ) );

      -- Verknüpfungen bleiben bestehen, es werden nur neue ergänzt

      _cursor := tabk.ab2_group__auto__dataquery__by__ab_ix(
                     _ab_ix,
                     1
                 );

      LOOP

        FETCH _cursor INTO _ab2_record;

        IF ( NOT FOUND ) THEN
          EXIT;
        END IF;

        IF ( _ab2_record.a2_ausw ) THEN
          CONTINUE;
        END IF;

        -- Hänge mich an
        _current_ab2_group := _current_ab2_group || _ab2_record.a2_id;

        -- Bei Wechsel der Resource UND bereits mehr als ein AG aggregiert, dann Datensätze absetzen
        IF ( _ab2_record.a2_ks <> _ab2_record.next_a2_ks OR _ab2_record.next_a2_ks IS NULL ) THEN -- TODO AXS: Klären: Reicht hier die Prüfung auf a2_ks? Es kann ja noch andere alternative Kostenstellen geben. Was passiert, wenn AG10 KS a und KS B hat B ist schneller und AG 20 hat KS A und KS C?

          IF ( array_length( _current_ab2_group, 1 ) > 1 ) THEN

            PERFORM tabk.ab2_group__add__by__a2_ids(VARIADIC _current_ab2_group);

          END IF;

          -- Array zurücksetzen, neue Gruppe
          _current_ab2_group := array[]::int[];

        END IF;

      END LOOP;

      CLOSE _cursor;

    END $$ LANGUAGE plpgsql;
--
SELECT tsystem.function__drop_by_regex( 'ab2_group__auto__dataquery__by__ab_ix', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_group__auto__dataquery__by__ab_ix( _abk_ix int, _direction int = 1 ) RETURNS REFCURSOR AS $$
    DECLARE
        _cursor REFCURSOR;
    BEGIN
        OPEN _cursor
        FOR

        WITH _data as (
            SELECT  a2_id, a2_n, a2_ab_ix, a2_ks, a2_ausw
              FROM ab2
                   JOIN ab2_wkstplan ON a2w_a2_id = a2_id -- TODO AXS: Klären: Warum Tabelle "ab2_wkstplan" hier angejoint, es wird keine Spalte von dieser verwendet?
             WHERE a2_ab_ix = _abk_ix
               -- AND ks_plan
               -- AND NOT a2_ende
               -- AND NOT ( a2_ausw = false OR a2_ta = 0 )
             ORDER BY a2_n * 1 -- TODO AXS: Klären: Warum hier Multiplikation mit 1? Ist das ein Trick?
        )
        SELECT lead(a2_id)      OVER ( ORDER BY a2_n )  AS next_a2_id,
               lag(a2_id)       OVER ( ORDER BY a2_n )  AS prev_a2_id,
               lead(a2_ks)      OVER ( ORDER BY a2_n )  AS next_a2_ks,
               lag(a2_ks)       OVER ( ORDER BY a2_n )  AS prev_a2_ks,
               *
          FROM _data
         ORDER BY a2_n * _direction;

        RETURN _cursor;

    END $$ LANGUAGE plpgsql STABLE;

--
CREATE TABLE ab2_group
    (
    a2g_id            serial    PRIMARY KEY,
    a2g_a2_id_from    integer   UNIQUE NOT NULL REFERENCES ab2 ( a2_id ) ON DELETE CASCADE,
    a2g_a2_id_to      integer   UNIQUE NOT NULL REFERENCES ab2 ( a2_id ) ON DELETE CASCADE
    );

CREATE UNIQUE INDEX ab2_group__a2_id__from_to ON ab2_group(a2g_a2_id_from, a2g_a2_id_to);


SELECT tsystem.function__drop_by_regex( 'ab2_groups__has', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_groups__has(_a2_id integer)
    RETURNS boolean
    AS $$
        SELECT EXISTS(SELECT true FROM ab2_group WHERE a2g_a2_id_from = _a2_id OR a2g_a2_id_to = _a2_id);
    $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;


SELECT tsystem.function__drop_by_regex('ab2__prior__by__ab2_group__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2__prior__by__ab2_group__get(_a2_id integer, OUT a2_id integer, OUT ab2_groups__ab_ix__prior integer)
    RETURNS record
    AS $$
        SELECT a2g_a2_id_from, a2_ab_ix FROM ab2_group JOIN ab2 ON a2_id = a2g_a2_id_from WHERE a2g_a2_id_to = _a2_id;
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
SELECT tsystem.function__drop_by_regex('ab2__next__by__ab2_group__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2__next__by__ab2_group__get(_a2_id integer, OUT a2_id integer, OUT ab2_groups__ab_ix__next integer)
    RETURNS record
    AS $$
        SELECT a2g_a2_id_to, a2_ab_ix FROM ab2_group JOIN ab2 ON a2_id = a2g_a2_id_to WHERE a2g_a2_id_from = _a2_id;
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--

-- Funktionen für Auflösen der Chains in alle Richtungen
-- https://ci.prodat-sql.de/sources/tests/suite/9/runner/1232
SELECT tsystem.function__drop_by_regex( 'ab2_groups__recursive__by__a2_id__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_groups__recursive__by__a2_id__get(_a2_id integer, _go_backward bool = true, OUT pos integer, OUT a2_id_src integer, OUT a2_id_chain integer, OUT depth integer) RETURNS SETOF record
    AS $$

         WITH RECURSIVE 
         _tree_forward AS (
              SELECT r.a2g_a2_id_from, r.a2g_a2_id_to, 0 AS depth, a2_ab_ix
                FROM ab2_group r
                JOIN ab2 ON a2_id = r.a2g_a2_id_from
               WHERE r.a2g_a2_id_from = _a2_id -- ich selbst verknüpft zu diesem
               UNION
              SELECT n.a2g_a2_id_from, n.a2g_a2_id_to, depth + 1, node_ab2.a2_ab_ix
                FROM ab2_group n
                JOIN _tree_forward ON n.a2g_a2_id_from = _tree_forward.a2g_a2_id_to
                JOIN ab2 node_ab2 ON node_ab2.a2_id = n.a2g_a2_id_to
         )
         ,_tree_backward AS (
              SELECT r.a2g_a2_id_to, r.a2g_a2_id_from, 0 AS depth, a2_ab_ix
                FROM ab2_group r
                JOIN ab2 ON a2_id = r.a2g_a2_id_to
               WHERE r.a2g_a2_id_to = _a2_id -- ich selbst bin verknüpft von diesem ausgehend
                 AND _go_backward 
               UNION
              SELECT n.a2g_a2_id_to, n.a2g_a2_id_from, depth + 1, node_ab2.a2_ab_ix
                FROM ab2_group n
                JOIN _tree_backward ON n.a2g_a2_id_to = _tree_backward.a2g_a2_id_from
                JOIN ab2 node_ab2 ON node_ab2.a2_id = n.a2g_a2_id_from
         )  
         -- von mir ausgehend nach unten Forward nodes
         ,_items_forward       AS (SELECT a2g_a2_id_to, a2g_a2_id_from, depth FROM _tree_forward WHERE true)
         ,_items_forward_max   AS (SELECT max(depth) AS max_depth FROM _items_forward WHERE true)
         -- von mir ausgehend rückwärts richtung root
         ,_items_backward      AS (SELECT a2g_a2_id_from, a2g_a2_id_to, (depth + 1) * -1 AS depth FROM _tree_backward)
         ,_items_backward_max  AS (SELECT max(depth + 1) * -1 AS max_depth FROM _tree_backward WHERE true)

         ,_items_backward_root AS (SELECT a2g_a2_id_from AS rootnode, depth FROM _items_backward JOIN _items_forward_max ON true WHERE max_depth IS null   
                                   ORDER BY depth LIMIT 1
                                   )

         SELECT row_number() OVER () AS pos, * FROM
         (                           
         SELECT null::integer AS a2g_a2_id_src, coalesce(_items_backward.a2g_a2_id_from, _items_forward.a2g_a2_id_from) AS a2g_a2_chain, null::integer AS depth FROM _items_forward LEFT JOIN _items_backward_max ON true LEFT JOIN _items_backward ON _items_backward.depth = max_depth WHERE _items_forward.depth = 0-- WHERE : wenn gar nichts gefunden wurde, auch keine Root-Zeile!         
         UNION
         SELECT null, rootnode, (depth -1 ) FROM _items_backward_root, _items_forward_max WHERE max_depth IS null -- wenn wir ganz rechts stehen, gibt es nur rückwärts und dies ist unser root
         UNION
         SELECT a2g_a2_id_from, a2g_a2_id_to, depth FROM _items_backward
         UNION
         SELECT a2g_a2_id_from, a2g_a2_id_to, depth FROM _items_forward
         ORDER BY depth NULLs FIRST
         ) AS r;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;

-- Rückwärts - für Rückwärts terminieren
SELECT tsystem.function__drop_by_regex( 'ab2_groups__recursive__by__a2_id__backward__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_groups__recursive__by__a2_id__backward__get(_a2_id integer, _go_forward bool = true, OUT pos integer, OUT a2_id_src integer, OUT a2_id_chain integer, OUT depth integer) RETURNS SETOF record
    AS $$

         WITH RECURSIVE 
         _tree_backward AS (
              SELECT r.a2g_a2_id_to, r.a2g_a2_id_from, 0 AS depth, a2_ab_ix
                FROM ab2_group r
                JOIN ab2 ON a2_id = r.a2g_a2_id_to
               WHERE r.a2g_a2_id_to = _a2_id -- ich selbst bin verknüpft von diesem ausgehend                 
               UNION
              SELECT n.a2g_a2_id_to, n.a2g_a2_id_from, depth + 1, node_ab2.a2_ab_ix
                FROM ab2_group n
                JOIN _tree_backward ON n.a2g_a2_id_to = _tree_backward.a2g_a2_id_from
                JOIN ab2 node_ab2 ON node_ab2.a2_id = n.a2g_a2_id_from
         )
         ,
         _tree_forward AS (
              SELECT r.a2g_a2_id_from, r.a2g_a2_id_to, 0 AS depth, a2_ab_ix
                FROM ab2_group r
                JOIN ab2 ON a2_id = r.a2g_a2_id_from
               WHERE r.a2g_a2_id_from = _a2_id -- ich selbst verknüpft zu diesem
                 AND _go_forward
               UNION
              SELECT n.a2g_a2_id_from, n.a2g_a2_id_to, depth + 1, node_ab2.a2_ab_ix
                FROM ab2_group n
                JOIN _tree_forward ON n.a2g_a2_id_from = _tree_forward.a2g_a2_id_to
                JOIN ab2 node_ab2 ON node_ab2.a2_id = n.a2g_a2_id_to
         )         
         -- von mir ausgehend rückwärts nach oben Backward richtung root
         ,_items_backward     AS (SELECT a2g_a2_id_to, a2g_a2_id_from, depth FROM _tree_backward WHERE true)
         ,_items_backward_max AS (SELECT max(depth) AS max_depth FROM _tree_backward WHERE true)
         -- von mir ausgehend nach unten Forward weitergehend node
         ,_items_forward      AS (SELECT a2g_a2_id_to, a2g_a2_id_from, (depth  + 1) * -1 AS depth FROM _tree_forward WHERE true)
         ,_items_forward_root AS (SELECT a2g_a2_id_from AS rootnode, depth FROM _tree_forward LEFT JOIN _items_backward_max ON true WHERE max_depth IS null
                                  ORDER BY depth LIMIT 1
                                 )
         --,_items_forward_root AS (SELECT a2g_a2_id_from AS rootnode, depth FROM _tree_forward, _items_backward_max ORDER BY depth LIMIT 1)
         
         SELECT row_number() OVER () AS pos, * FROM
         (                  
         SELECT null::integer AS a2g_a2_id_src, coalesce(rootnode, a2g_a2_id_from) AS a2g_a2_chain, null::integer AS depth FROM _items_backward, _items_backward_max LEFT JOIN _items_forward_root ON true WHERE _items_backward.depth = max_depth -- WHERE : wenn gar nichts gefunden wurde, auch keine Root-Zeile!
         UNION
         SELECT null, rootnode, depth FROM _items_forward_root, _items_backward_max WHERE max_depth IS null -- wenn wir ganz links stehen, gibt es nur vorwärts und dies ist unser root
         UNION
         SELECT a2g_a2_id_from, a2g_a2_id_to, depth FROM _items_forward
         UNION
         SELECT a2g_a2_id_from, a2g_a2_id_to, depth FROM _items_backward
         ORDER BY depth NULLs LAST
         ) AS r;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;

SELECT tsystem.function__drop_by_regex( 'ab2_groups__recursive__by__a2_id__by__direction__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_groups__recursive__by__a2_id__by__direction__get(_a2_id integer, _direction varchar, OUT pos integer, OUT a2_id_src integer, OUT a2_id_chain integer, OUT depth integer) RETURNS SETOF record
    AS $$
    BEGIN
        IF _direction = 'forward' THEN
            RETURN QUERY SELECT g.pos, g.a2_id_src, g.a2_id_chain, g.depth FROM tabk.ab2_groups__recursive__by__a2_id__get(_a2_id) g;
            RETURN;
        END IF;
        IF _direction = 'backward' THEN
            RETURN QUERY SELECT g.pos, g.a2_id_src, g.a2_id_chain, g.depth FROM tabk.ab2_groups__recursive__by__a2_id__backward__get(_a2_id) g;
            RETURN;
        END IF;

        RAISE EXCEPTION 'ab2_groups__recursive__by__a2_id__by__direction__get: unknown direction: %', _direction;

    END $$ LANGUAGE plpgsql STABLE;


--
SELECT tsystem.function__drop_by_regex( 'ab2_groups__recursive__by__ab_ix__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2_groups__recursive__by__ab_ix__get(_ab_ix integer, OUT pos integer, OUT a2_id_from integer, OUT a2_id_to integer) RETURNS SETOF record
    AS $$
    DECLARE _ab2s record;
            _ab2_groups record;
            _resarray integer[] = array[]::int[];
    BEGIN
        -- laufe über alle arbeitsgänge
        -- löse rekursiv auf und gebe zurück, schreibe in array
        FOR _ab2s IN SELECT a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix ORDER BY a2_n
        LOOP

            a2_id_to   := null;

            FOR _ab2_groups IN SELECT * FROM tabk.ab2_groups__recursive__by__a2_id__get(_ab2s.a2_id)
            LOOP

                pos        := _ab2_groups.pos;
                a2_id_from := _ab2_groups.a2_id_src;
                a2_id_to   := _ab2_groups.a2_id_chain;

                -- Wenn a2_id noch nicht zurückgegeben wurde, dann zurückgeben! Wenn zB 2 folge AGs verkettet sind, würde es den 2. sonst 2 mal zurückgeben: einmal als Verkettung des Ersten und einmal als sich selbst!
                IF NOT a2_id_to = ANY(_resarray) THEN
                    _resarray := _resarray || a2_id_to;
                    RETURN NEXT;
                END IF;

            END LOOP;

            -- wenn keine FolgeAGs, dann dennoch uns selbst als AG
            IF a2_id_to IS null THEN
               a2_id_from := _ab2s.a2_id;
               RETURN NEXT;
            END IF;

        END LOOP;

        RETURN;
    END $$ LANGUAGE plpgsql;
--